<?php
require_once '../config/database.php';

header('Content-Type: application/json');

$database = new Database();
$db = $database->getConnection();

try {
    // Sélectionne les spectacles uniques qui ont au moins une séance future,
    // triés par la date de leur prochaine séance.
    $query = "SELECT 
                    p.id as performance_id, 
                    p.title as performance_title, 
                    p.poster_url,
                    p.slug as performance_slug,
                    c.name as category_name, 
                    AVG(r.rating) as avg_rating, 
                    COUNT(DISTINCT r.id) as review_count,
                    MIN(s.show_datetime) as next_show_datetime -- Date de la prochaine séance pour ce spectacle
                FROM performances p
                JOIN schedules s ON p.id = s.performance_id
                LEFT JOIN categories c ON p.category_id = c.id
                LEFT JOIN reviews r ON p.id = r.performance_id AND r.is_approved = 1
                WHERE s.show_datetime > NOW() AND s.status = 'open' AND p.status = 'online'
                GROUP BY p.id, p.title, p.poster_url, p.slug, c.name 
                ORDER BY next_show_datetime ASC";
    
    $stmt = $db->prepare($query);
    $stmt->execute();
    
    $upcoming_performances = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'data' => $upcoming_performances]);

} catch (PDOException $e) {
    http_response_code(500);
    error_log("Upcoming Performances API Error: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Erreur serveur lors de la récupération des spectacles à venir.', 'details' => $e->getMessage()]);
}
?>
